#pragma once

#include <string>



/* Usage example:

for(auto& p : ParameterReader(argc, argv))
{
	if("-i" == p.Name()) // input filename
	{
		p.ReadString();
	}
	else if("-res" == p.Name()) // resolution
	{
		newResolution[0] = p.ReadInt();
		newResolution[1] = p.ReadInt();
		newResolution[2] = p.ReadInt();
	}
	...
}

*/


class ParameterReader
{
public:
	class Exception : public std::exception
	{
	public:
		Exception(std::string message) : message(message) {}
		virtual const char* what() const override
		{
			return message.c_str();
		}
	private:
		std::string message;
	};

	ParameterReader(int argc, char* argv[]):
		m_argc(argc),
		m_argv(argv),
		m_i(1)
	{
		if(m_i < argc)
			m_currentParameterName = argv[m_i];
	}

	// Functions for looping:
	// these are a bit hacky, but this way no additional iterator class is required...
	ParameterReader& begin()
	{
		return *this;
	}
	ParameterReader& end()
	{
		return *this;
	}
	ParameterReader& operator*()
	{
		return *this;
	}
	bool operator!= (ParameterReader& r)
	{
		return m_i < m_argc;
	}
	ParameterReader& operator++ ()
	{
		m_i++;
		if(m_i < m_argc)
			m_currentParameterName = m_argv[m_i];
		return *this;
	}


	std::string Name() const
	{
		return m_currentParameterName;
	}

	std::string ReadString()
	{
		m_i++;
		if(m_i >= m_argc)
			throw Exception("too few parameters for "+m_currentParameterName);
		m_currentParameterName = m_argv[m_i];

		return Name();
	}
	int ReadInt()
	{
		return std::stoi(ReadString());
	}
	float ReadFloat()
	{
		return std::stof(ReadString());
	}
private:
	int m_argc;
	char** m_argv;
	int m_i; // iterator variable pointing at the current parameter to be read
	std::string m_currentParameterName;
};
